% A document class for generating U of Waterloo E&CE work reports.
% Copyright (C) 2002  Simon Law
% 
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2 of the License, or
% (at your option) any later version.
% 
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% 
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{uw-ece-workreport}[2003/01/11 v1.1]
\DeclareOption*{%
  \PassOptionsToClass {\CurrentOption}{article}}
\ProcessOptions
\LoadClass[titlepage]{article}
\newcommand{\UWECEWorkReportVersion}{1.1}

%%%%%%%%%%
%% MARGINS
%%%%%%%%%%
% Set the left and right margins to 1.5in, and the top and bottom margins
% to 1.0in, as specified in Section 9.8.5 of the CECS Co-op Student Reference
% Manual.
\RequirePackage{fullpage}
\oddsidemargin 0.5in
\evensidemargin \oddsidemargin
\textwidth 5.5in
\textheight 9in

%%%%%%%%%%
%% SPACING
%%%%%%%%%%
% We need to change the line spacing throughout the document, so we will
% use the setspace package.
\RequirePackage{setspace}

% Each paragraph must be followed by a blank line.
\setlength{\parskip}{\medskipamount}

%%%%%%
%% URL
%%%%%%
% We should support the creation of URLs.  As well, let us use a saner font.
\RequirePackage{url}
\urlstyle{sf}

%%%%%%%%%%%%
%% VARIABLES
%%%%%%%%%%%%
% We want to make sure that the old variables stick around
\def\author#1{\gdef\@author{#1}\renewcommand\@@author{#1}}
  \newcommand\@@author{\ClassError{uw-ece-workreport}%
    {No \noexpand\author given}{}}
\def\date#1{\gdef\@date{#1}\renewcommand\@@date{#1}}
  \newcommand\@@date{\today}
\def\title#1{\gdef\@title{#1}\renewcommand\@@title{#1}}
  \newcommand\@@title{\ClassError{uw-ece-workreport}%
    {No \noexpand\title given}{}}

% New variables
\newcommand{\uwid}[1]{\renewcommand{\@uwid}{#1}}
  \newcommand{\@uwid}{\ClassError{uw-ece-workreport}%
    {No \noexpand\uwid given}{}}
\newcommand{\email}[1]{\renewcommand{\@email}{#1}}
  \newcommand{\@email}{\ClassError{uw-ece-workreport}%
    {No \noexpand\email given}{}}
\newcommand{\address}[1]{\renewcommand{\@address}{#1}}
  \newcommand{\@address}{\ClassError{uw-ece-workreport}%
    {No \noexpand\address given}{}}
\newcommand{\employer}[1]{\renewcommand{\@employer}{#1}}
  \newcommand{\@employer}{\ClassError{uw-ece-workreport}%
    {No \noexpand\employer given}{}}
\newcommand{\employeraddress}[1]{\renewcommand{\@employeraddress}{#1}}
  \newcommand{\@employeraddress}{\ClassError{uw-ece-workreport}%
    {No \noexpand\employeraddress given}{}}
\newcommand{\school}[1]{\renewcommand{\@school}{#1}}
  \newcommand{\@school}{\ClassError{uw-ece-workreport}%
    {No \noexpand\school given}{}}
\newcommand{\faculty}[1]{\renewcommand{\@faculty}{#1}}
  \newcommand{\@faculty}{\ClassError{uw-ece-workreport}%
    {No \noexpand\faculty given}{}}
\newcommand{\term}[1]{\renewcommand{\@term}{\textsc{\lowercase{#1}}}}
  \newcommand{\@term}{\ClassError{uw-ece-workreport}%
    {No \noexpand\term given}{}}
\newcommand{\program}[1]{\renewcommand{\@program}{#1}}
  \newcommand{\@program}{\ClassError{uw-ece-workreport}%
    {No \noexpand\program given}{}}
\newcommand{\chair}[1]{\renewcommand{\@chair}{#1}}
  \newcommand{\@chair}{\ClassError{uw-ece-workreport}%
    {No \noexpand\chair given}{}}
\newcommand{\chairaddress}[1]{\renewcommand{\@chairaddress}{#1}}
  \newcommand{\@chairaddress}{\ClassError{uw-ece-workreport}%
    {No \noexpand\chairaddress given}{}}
\newcommand{\confidential}[1]{\renewcommand{\@confidential}{#1}}
  \newcommand{\@confidential}{}

% We will also define a way to access these new variables, in case the
% person wishes to refer to them within the document.
\newcommand{\theauthor}{\@@author}
\newcommand{\thetitle}{\@@title}
\newcommand{\thedate}{\@@date}
\newcommand{\theuwid}{\@uwid}
\newcommand{\theemail}{\@email}
\newcommand{\theaddress}{\@address}
\newcommand{\theemployer}{\@employer}
\newcommand{\theemployeraddress}{\@employeraddress}
\newcommand{\theschool}{\@school}
\newcommand{\thefaculty}{\@faculty}
\newcommand{\theterm}{\@term}
\newcommand{\theprogram}{\@program}
\newcommand{\thechair}{\@chair}
\newcommand{\thechairaddress}{\@chairaddress}

%%%%%%%%%%%%%
%% TITLE PAGE
%%%%%%%%%%%%%
% Here, we will use a document format that is pleasing to the eye, and contains
% all the material required by the E&CE guidelines.  You will want to use
% a clear cover to let this show through.
\RequirePackage{textcase}
\renewcommand\maketitle{\begin{titlepage}%
  \let\footnotesize\small
  \let\footnoterule\relax
  \let \footnote \thanks
  \begin{center}
    {\large \MakeTextUppercase{\@school} \par \@faculty}%
  \end{center}
  \null\vfil
  \vskip 2in
  \begin{center}%
    {\huge \MakeTextUppercase{\@title} \par}%
  \end{center}\par
  \null\vfil\vskip 1.5in
  \begin{center}%
    {\large \@employer\\ \@employeraddress\par \textit{\@confidential}}%
  \end{center}\par
  \null\vfil%
  \begin{center}%
    {\large
      Prepared by\\
      \begin{tabular}[t]{c}%
        \@author\\
	ID \#\@uwid\\
	\@email\\
	\@term{} \@program
      \end{tabular}\par}%
    {\large \@date \par}%       % Set date in \large size.
  \end{center}
  \@thanks
  \end{titlepage}%
  \setcounter{footnote}{0}%
  \global\let\thanks\relax
  \global\let\maketitle\relax
  \global\let\@thanks\@empty
  \global\let\@author\@empty
  \global\let\@date\@empty
  \global\let\@title\@empty
  \global\let\title\relax
  \global\let\author\relax
  \global\let\date\relax
  \global\let\and\relax
  \global\let\confindential\relax
  \global\let\@confindential\@empty
}

%%%%%%%%%%%%%%%%%%%%%%
%% LETTER OF SUBMITTAL
%%%%%%%%%%%%%%%%%%%%%%
% Since the Title Page must be Page 1, the Letter of Submittal must be page 2.
% As well, this page should have no page numbering.
\newenvironment{letter}%
  {%
    \thispagestyle{empty}\setcounter{page}{2}\singlespacing\noindent%
    \@@author\\\@address\par\noindent%
    \@@date \par\noindent%
    \@chair, Chair\\*\@chairaddress\par\noindent%
    Dear \@chair:%
    \begin{center}\textbf{Re: Submission of my work term report.}\end{center}%
  }{%
    % Add in the mandatory disclaimer
    \par I hereby confirm that I have received no further help other than what
    is mentioned above in writing this report.  I also confirm that this report
    has not been previously submitted for academic credit at this or any other
    academic institution.\par\noindent%
    % Signature
    Yours sincerely,\\*%
    \rule{0in}{0.3in}\\*\rule{3in}{0.01in}\\*%
    \@@author, \@uwid%
    \doublespacing%
    % Clean up all those variables
    \renewcommand{\@@author}{\@empty}
    \renewcommand{\@@title}{\@empty}
    \renewcommand{\@@date}{\@empty}
    \renewcommand{\uwid}{\relax}
    \renewcommand{\@uwid}{\@empty}
    \renewcommand{\email}{\relax}
    \renewcommand{\@email}{\@empty}
    \renewcommand{\employer}{\relax}
    \renewcommand{\@employer}{\@empty}
    \renewcommand{\employeraddress}{\relax}
    \renewcommand{\@employeraddress}{\@empty}
    \renewcommand{\address}{\relax}
    \renewcommand{\@address}{\@empty}
    \renewcommand{\chair}{\relax}
    \renewcommand{\@chair}{\@empty}
    \renewcommand{\chairaddress}{\relax}
    \renewcommand{\@chairaddress}{\@empty}
    \renewcommand{\school}{\relax}
    \renewcommand{\@school}{\@empty}
    \renewcommand{\faculty}{\relax}
    \renewcommand{\@faculty}{\@empty}
    \renewcommand{\term}{\relax}
    \renewcommand{\@term}{\@empty}
    \renewcommand{\program}{\relax}
    \renewcommand{\@program}{\@empty}
  }

% We shall emulate the \frontmatter, \mainmatter, \backmatter commands in
% this class.  Front matter pages are numbered with roman numerals; main 
% and back matter pages are numbered with arabic numerals.  In the front 
% and back matter, the \section command does not have a section number, 
% but it is in the table of contents.

\newcommand{\frontmatter}
  {%
    \clearpage%
    \@notmainsect%
    \pagenumbering{roman}%
    \doublespacing%
  }

\newcommand{\mainmatter}
  {%
    \clearpage%
    \@mainsect%
    \pagenumbering{arabic}%
  }

\newcommand{\backmatter}
  {%
    \clearpage%
    \@notmainsect%
  }

\newcommand{\@notmainsect}
  {%
    \def\@sect##1##2##3##4##5##6[##7]##8{%
      \@tempskipa ##5\relax
      \ifdim \@tempskipa>\z@
        \begingroup
          ##6{%
            \@hangfrom{\hskip ##3}%
              \interlinepenalty \@M ##8\@@par}%
        \endgroup
        \csname ##1mark\endcsname{##7}%
        \addcontentsline{toc}{##1}{%
          ##7}%
      \else
        \def\@svsechd{%
          ##6{\hskip ##3\relax
          \@svsec ##8}%
          \csname ##1mark\endcsname{##7}%
          \addcontentsline{toc}{##1}{%
            ##7}}%
      \fi
      \@xsect{##5}}%
  }
\newcommand{\@mainsect}
  {%
    \def\@sect##1##2##3##4##5##6[##7]##8{%
      \ifnum ##2>\c@secnumdepth
        \let\@svsec\@empty
      \else
        \refstepcounter{##1}%
        \protected@edef\@svsec{\@seccntformat{##1}\relax}%
      \fi
      \@tempskipa ##5\relax
      \ifdim \@tempskipa>\z@
        \begingroup
          ##6{%
            \@hangfrom{\hskip ##3\relax\@svsec}%
              \interlinepenalty \@M ##8\@@par}%
        \endgroup
        \csname ##1mark\endcsname{##7}%
        \addcontentsline{toc}{##1}{%
          \ifnum ##2>\c@secnumdepth \else
            \protect\numberline{\csname the##1\endcsname}%
          \fi
          ##7}%
      \else
        \def\@svsechd{%
          ##6{\hskip ##3\relax
          \@svsec ##8}%
          \csname ##1mark\endcsname{##7}%
          \addcontentsline{toc}{##1}{%
            \ifnum ##2>\c@secnumdepth \else
              \protect\numberline{\csname the##1\endcsname}%
            \fi
            ##7}}%
      \fi
      \@xsect{##5}}%
  }

\let\@sectionorig\section
\renewcommand{\section}{\clearpage \@sectionorig}

%%%%%%%%%%%%%%%%%%%%
%% TABLE OF CONTENTS
%%%%%%%%%%%%%%%%%%%%
% Make the Table of Contents use the correct title
\renewcommand{\contentsname}
  {%
     Table of Contents%
  }

% Make it single spaced
\let\@tocorig\tableofcontents
\renewcommand{\tableofcontents}
  {%
    \clearpage%
    \begin{singlespacing}%
    \@tocorig \par
    \end{singlespacing}%
  }

% Use dot leaders in front of each page number, so no exceptions for section
% titles.
\renewcommand*\l@section[2]%
  {%
    \ifnum \c@tocdepth >\m@ne
      \addpenalty{-\@highpenalty}%
      \vskip 1.0em \@plus\p@
      \setlength\@tempdima{1.5em}%
      \begingroup
        \parindent \z@ \rightskip \@pnumwidth
        \parfillskip -\@pnumwidth
        \leavevmode \bfseries
        \advance\leftskip\@tempdima
        \hskip -\leftskip
        #1\nobreak\
          \leaders\hbox{$\m@th
          \mkern \@dotsep mu\hbox{.}\mkern \@dotsep
          mu$}\hfil\nobreak\hb@xt@\@pnumwidth{\hss #2}\par
        \penalty\@highpenalty
      \endgroup
    \fi%
  }

% Add the List of Figures and List of Tables to the Table of Contents
\let\@loforig\listoffigures
\renewcommand{\listoffigures}
  {%
    \clearpage%
    \@loforig%
    \addcontentsline{toc}{section}{List of Figures}%
  }
\let\@lotorig\listoftables
\renewcommand{\listoftables}
  {%
    \clearpage%
    \@lotorig%
    \addcontentsline{toc}{section}{List of Tables}%
  }

%%%%%%%%%%%%%%%%%%%%%
%% TABLES AND FIGURES
%%%%%%%%%%%%%%%%%%%%%
% Tables and Figures must come after they are referenced in the text.  The
% only way to guarantee this is to change the default `loc' argument to 
% `htbp'.
\let\@tableorig\table
\let\end@tableorig\endtable
\renewenvironment{table}[1][htbp]{\begin{@tableorig}[#1]}{\end{@tableorig}}

\let\@figureorig\figure
\let\end@figureorig\endfigure
\renewenvironment{figure}[1][htbp]{\begin{@figureorig}[#1]}{\end{@figureorig}}

%%%%%%%%%%%%%
%% REFERENCES
%%%%%%%%%%%%%
% Use the IEEE bibliography style, as required by the E&CE guidelines.
\bibliographystyle{ieeetr}

% Add the References section to the Table of Contents.  As well, make it 
% single spaced.
\let\@biborig\bibliography
\renewcommand{\bibliography}[1]
  {%
    \clearpage%
    \begin{singlespacing}%
    \addcontentsline{toc}{section}{References}%
    \@biborig{#1}\par
    \end{singlespacing}%
  }

\endinput

